/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/    

/**
 * \file    spiFlash.c
 *
 * \brief   Support routines for testing the SPI-NAND Flash
 *
 * This file contains the support routines for testing SPI-NAND Flash.
 *
 * \author  0043
 *
 * \version 01a,13sep,2010 Created
 */

/* ------------------------------------------------------------------------ *
 *  Defines				                                                    *
 * ------------------------------------------------------------------------ */
#define SPIFLASH_SIZE             0x00400000
#define SPIFLASH_BASE             0x00000000
#define SPIFLASH_PAGESIZE         256
#define SPIFLASH_PAGEMASK         0xffffffc0
#define SPIFLASH_MANUF_ID		  0xEF

/* ------------------------------------------------------------------------ *
 *  SPI FLASH Commands                                                        *
 * ------------------------------------------------------------------------ */
#define SPIFLASH_CMD_WRSR         0x01
#define SPIFLASH_CMD_WRITE        0x02
#define SPIFLASH_CMD_READ         0x03
#define SPIFLASH_CMD_WRDI         0x04
#define SPIFLASH_CMD_RDSR         0x05
#define SPIFLASH_CMD_WREN         0x06
#define SPIFLASH_CMD_READID		  0x90

/* ------------------------------------------------------------------------ *
 *  SPIOCP Module                                                           *
 * ------------------------------------------------------------------------ */
#define MCSPI_BASE                  0x48030000
#define MCSPI_REVISION              *( volatile UINT32* )( MCSPI_BASE + 0x100)
#define MCSPI_SYSCONFIG             *( volatile UINT32* )( MCSPI_BASE + 0x110 )
#define MCSPI_SYSSTATUS             *( volatile UINT32* )( MCSPI_BASE + 0x114 )
#define MCSPI_IRQSTATUS             *( volatile UINT32* )( MCSPI_BASE + 0x118 )
#define MCSPI_IRQENABLE             *( volatile UINT32* )( MCSPI_BASE + 0x11C )
#define MCSPI_WAKEUPENABLE          *( volatile UINT32* )( MCSPI_BASE + 0x120 )
#define MCSPI_SYST                  *( volatile UINT32* )( MCSPI_BASE + 0x124 )
#define MCSPI_MODULCTRL             *( volatile UINT32* )( MCSPI_BASE + 0x128 )
#define MCSPI_CH0CONF               *( volatile UINT32* )( MCSPI_BASE + 0x12C )
#define MCSPI_CH0STAT               *( volatile UINT32* )( MCSPI_BASE + 0x130 )
#define MCSPI_CH0CTRL               *( volatile UINT32* )( MCSPI_BASE + 0x134 )
#define MCSPI_TX0                   *( volatile UINT32* )( MCSPI_BASE + 0x138 )
#define MCSPI_RX0                   *( volatile UINT32* )( MCSPI_BASE + 0x13C )
#define MCSPI_CH1CONF               *( volatile UINT32* )( MCSPI_BASE + 0x140 )
#define MCSPI_CH1STAT               *( volatile UINT32* )( MCSPI_BASE + 0x144 )
#define MCSPI_CH1CTRL               *( volatile UINT32* )( MCSPI_BASE + 0x148 )
#define MCSPI_TX1                   *( volatile UINT32* )( MCSPI_BASE + 0x14C )
#define MCSPI_RX1                   *( volatile UINT32* )( MCSPI_BASE + 0x150 )
#define MCSPI_CH2CONF               *( volatile UINT32* )( MCSPI_BASE + 0x154 )
#define MCSPI_CH2STAT               *( volatile UINT32* )( MCSPI_BASE + 0x158 )
#define MCSPI_CH2CTRL               *( volatile UINT32* )( MCSPI_BASE + 0x15C )
#define MCSPI_TX2                   *( volatile UINT32* )( MCSPI_BASE + 0x160 )
#define MCSPI_RX2                   *( volatile UINT32* )( MCSPI_BASE + 0x164 )
#define MCSPI_CH3CONF               *( volatile UINT32* )( MCSPI_BASE + 0x168 )
#define MCSPI_CH3STAT               *( volatile UINT32* )( MCSPI_BASE + 0x16C )
#define MCSPI_CH3CTRL               *( volatile UINT32* )( MCSPI_BASE + 0x170 )
#define MCSPI_TX3                   *( volatile UINT32* )( MCSPI_BASE + 0x174 )
#define MCSPI_RX3                   *( volatile UINT32* )( MCSPI_BASE + 0x178 )
#define MCSPI_XFERLEVEL             *( volatile UINT32* )( MCSPI_BASE + 0x17C )
#define MCSPI_DAFTX                 *( volatile UINT32* )( MCSPI_BASE + 0x180 )
#define MCSPI_DAFRX                 *( volatile UINT32* )( MCSPI_BASE + 0x1A0 )

/* ------------------------------------------------------------------------ *
 *  Prototype                                                               *
 * ------------------------------------------------------------------------ */
void spiflash_init( );
void spiflash_read( UINT16 src, UINT32 dst, UINT32 length );
void spiflash_write( UINT32 src, UINT16 dst, UINT32 length );
STATUS spiFlash_readID ();
